# Integração - Comunicação e Protocolos

## Protocolo de Comunicação

- **Protocolo**: HTTP/HTTPS
- **Formato**: JSON
- **Autenticação**: Header `X-API-Key`
- **CORS**: Habilitado

## Padrão de Requisição

```http
GET /api/pobj/resumo?segmentoId=1&dataInicio=2024-01-01&dataFim=2024-12-31 HTTP/1.1
Host: api.example.com
X-API-Key: sua-api-key-aqui
X-User-Funcional: 12345
Content-Type: application/json
```

## Padrão de Resposta

### Sucesso

```json
{
  "success": true,
  "data": {
    "cards": [...],
    "classifiedCards": [...],
    "variableCard": [...],
    "businessSnapshot": {
      "total": 22,
      "elapsed": 15,
      "remaining": 7
    }
  }
}
```

### Erro

```json
{
  "success": false,
  "data": {
    "error": "Recurso não encontrado",
    "code": "NOT_FOUND",
    "details": {
      "resource": "produto"
    },
    "timestamp": "2024-01-15T10:30:00+00:00",
    "request_id": "req-123456"
  }
}
```

## Headers Importantes

- `X-API-Key`: Chave de autenticação (obrigatória)
- `X-User-Funcional`: Funcional do usuário (opcional)
- `Content-Type`: `application/json` (para POST/PUT)

---

**Próximo**: [Endpoints da API](./02-endpoints.md)
