# Frontend - Estrutura de Diretórios

## Estrutura Completa

```
frontend/
├── src/
│   ├── components/           # Componentes Vue reutilizáveis
│   │   ├── Button.vue
│   │   ├── Filters.vue       # Barra de filtros global
│   │   ├── Header.vue
│   │   ├── Footer.vue
│   │   ├── omega/            # Componentes Omega
│   │   └── encantabra/        # Componentes Encantabra
│   │
│   ├── views/                # Páginas/rotas
│   │   ├── Home.vue          # Resumo
│   │   ├── Detalhes.vue
│   │   ├── Ranking.vue
│   │   ├── Omega.vue
│   │   └── Encantabra.vue
│   │
│   ├── services/             # Serviços de API
│   │   ├── api.ts            # Cliente HTTP base
│   │   ├── resumoService.ts
│   │   ├── detalhesService.ts
│   │   └── omegaService.ts
│   │
│   ├── composables/          # Composables Vue (lógica reutilizável)
│   │   ├── useGlobalFilters.ts
│   │   ├── useResumoData.ts
│   │   ├── useOmega.ts
│   │   └── usePDFExport.ts
│   │
│   ├── router/               # Vue Router
│   │   └── index.ts
│   │
│   ├── config/               # Configurações
│   │   └── api.ts            # Config API (URL, Key)
│   │
│   ├── types/                # TypeScript types
│   │   ├── index.ts
│   │   ├── omega.ts
│   │   └── encantabra.ts
│   │
│   ├── utils/                # Funções utilitárias
│   │   ├── date.ts
│   │   └── format.ts
│   │
│   └── assets/               # CSS, imagens, fontes
│       ├── style.css
│       ├── bradesco-theme.css
│       └── animations.css
│
├── public/                   # Arquivos estáticos
└── dist/                     # Build de produção
```

## Convenções de Nomenclatura

- **Components**: PascalCase (ex: `ResumoKPI.vue`)
- **Composables**: camelCase com prefixo `use` (ex: `useResumoData.ts`)
- **Services**: camelCase (ex: `resumoService.ts`)
- **Types**: PascalCase (ex: `ResumoPayload`)

---

**Próximo**: [Services](./02-services.md)
