# Guia de Desenvolvimento - Adicionar Novo Composable

## Estrutura Base

```typescript
// src/composables/useNovoData.ts
import { ref, computed } from 'vue'
import { getNovo } from '@/services/novoService'

const dados = ref<NovoData | null>(null)
const loading = ref(false)
const error = ref<string | null>(null)

export function useNovoData() {
  const loadData = async () => {
    loading.value = true
    error.value = null
    
    try {
      const result = await getNovo()
      dados.value = result
    } catch (e) {
      error.value = e instanceof Error ? e.message : 'Erro desconhecido'
    } finally {
      loading.value = false
    }
  }
  
  return {
    dados: computed(() => dados.value),
    loading: computed(() => loading.value),
    error: computed(() => error.value),
    loadData
  }
}
```

## Uso no Componente

```vue
<script setup lang="ts">
import { useNovoData } from '@/composables/useNovoData'

const { dados, loading, error, loadData } = useNovoData()

onMounted(() => {
  loadData()
})
</script>
```

---

**Próximo**: [Adicionar Novo Service](./03-novo-service.md)
