# Guia de Desenvolvimento - Adicionar Novo Endpoint

## Passo a Passo

### 1. Criar Use Case

```php
<?php
// src/Application/UseCase/Pobj/NovoUseCase.php
namespace App\Application\UseCase\Pobj;

use App\Domain\DTO\FilterDTO;
use App\Repository\Pobj\NovoRepository;

class NovoUseCase
{
    private $repository;
    
    public function __construct(NovoRepository $repository)
    {
        $this->repository = $repository;
    }
    
    public function handle(?FilterDTO $filters = null): array
    {
        $dados = $this->repository->findAll($filters);
        return $dados;
    }
}
```

### 2. Criar Repository

```php
<?php
// src/Repository/Pobj/NovoRepository.php
namespace App\Repository\Pobj;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;

class NovoRepository extends ServiceEntityRepository
{
    public function findAll(?FilterDTO $filters = null): array
    {
        // Implementação
    }
}
```

### 3. Criar Controller

```php
<?php
// src/Controller/Pobj/NovoController.php
namespace App\Controller\Pobj;

use App\Application\UseCase\Pobj\NovoUseCase;
use App\Controller\ControllerBase;
use App\Domain\DTO\FilterDTO;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class NovoController extends ControllerBase
{
    private $useCase;
    
    public function __construct(NovoUseCase $useCase)
    {
        $this->useCase = $useCase;
    }
    
    /**
     * @Route("/api/pobj/novo", name="api_pobj_novo", methods={"GET"})
     */
    public function handle(Request $request): JsonResponse
    {
        $filters = new FilterDTO($request->query->all());
        $result = $this->useCase->handle($filters);
        return $this->success($result);
    }
}
```

### 4. Registrar no services.yaml (se necessário)

```yaml
# config/services.yaml
services:
    App\Application\UseCase\Pobj\NovoUseCase:
        arguments:
            $repository: '@App\Repository\Pobj\NovoRepository'
```

---

**Próximo**: [Adicionar Novo Composable](./02-novo-composable.md)
