# Banco de Dados - Modelo de Dados

## Visão Geral

O banco de dados segue um modelo **dimensional** (Data Warehouse), com separação clara entre:

- **Tabelas Fato (F_*)**: Dados transacionais que mudam ao longo do tempo
- **Tabelas Dimensão (D_*)**: Dados de referência relativamente estáticos
- **Tabelas Omega**: Sistema de gestão de chamados/tickets
- **Tabelas de Estrutura**: Hierarquia organizacional

## Convenções de Nomenclatura

### Prefixos

- **`f_*`**: Tabelas Fato (fatos transacionais)
- **`d_*`**: Tabelas Dimensão (dimensões de referência)
- **`omega_*`**: Tabelas do sistema Omega (gestão de chamados)
- Sem prefixo: Tabelas de estrutura organizacional (cargos, segmentos, diretorias, etc.)

### Padrões

- Nomes em **snake_case** (minúsculas com underscore)
- Chaves primárias: `id` (auto-incremento) ou campo natural
- Chaves estrangeiras: `{tabela}_id` ou nome do campo referenciado
- Timestamps: `created_at`, `updated_at` (quando aplicável)

## Estrutura Geral

```
┌─────────────────────────────────────────────────────────┐
│              TABELAS DE ESTRUTURA                        │
│  segmentos → diretorias → regionais → agencias          │
│  cargos                                                  │
└──────────────────────┬──────────────────────────────────┘
                       │
┌──────────────────────▼──────────────────────────────────┐
│              TABELAS DIMENSÃO (D_*)                      │
│  d_estrutura (funcionários/gerentes)                    │
│  d_produtos (produtos/indicadores)                       │
│  d_calendario (datas)                                    │
│  d_status_indicadores (status)                           │
└──────────────────────┬──────────────────────────────────┘
                       │
┌──────────────────────▼──────────────────────────────────┐
│              TABELAS FATO (F_*)                          │
│  f_meta (metas mensais)                                  │
│  f_realizados (valores realizados)                       │
│  f_pontos (pontuação)                                    │
│  f_variavel (variáveis)                                  │
│  f_detalhes (detalhes de contratos)                      │
│  f_campanhas (campanhas)                                 │
│  f_leads_propensos (leads)                               │
│  f_historico_ranking_pobj (histórico de ranking)         │
└──────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────┐
│              TABELAS OMEGA                               │
│  omega_usuarios (usuários do sistema)                    │
│  omega_departamentos (departamentos)                     │
│  omega_status (status de chamados)                       │
│  omega_chamados (chamados/tickets)                       │
└─────────────────────────────────────────────────────────┘
```

## Hierarquia Organizacional

```
segmentos
  └── diretorias
        └── regionais
              └── agencias
                    └── d_estrutura (funcionários)
```

## Relacionamentos Principais

### Fato → Dimensão

- `f_meta`, `f_realizados`, `f_pontos` → `d_produtos` (via `produto_id`)
- `f_meta`, `f_realizados`, `f_pontos` → `d_estrutura` (via `funcional`)
- Todas as tabelas fato → `d_calendario` (via campos de data)

### Dimensão → Estrutura

- `d_estrutura` → `cargos` (via `cargo_id`)
- `d_estrutura` → `segmentos`, `diretorias`, `regionais`, `agencias`
- `d_produtos` → `familia`, `indicador`, `subindicador`

## Tipos de Dados Principais

- **DECIMAL(18,2)**: Valores monetários e métricas numéricas
- **VARCHAR**: Strings de tamanho variável
- **DATE**: Datas (sem hora)
- **DATETIME**: Datas com hora
- **TINYINT(1)**: Booleanos (0/1)
- **BIGINT**: IDs grandes (auto-incremento)

## Índices Estratégicos

O banco utiliza índices para otimizar:

1. **Queries de agregação**: Por produto, funcional, data
2. **Filtros hierárquicos**: Por estrutura organizacional
3. **Joins frequentes**: Entre fato e dimensão
4. **Ordenação**: Por ranking, data, valores

---

**Próximo**: [Tabelas e Estrutura](./02-tabelas.md)
