# Documentação Técnica do Projeto

> **Versão**: 1.0  
> **Última Atualização**: 2024  
> **Público-Alvo**: Equipe de Desenvolvimento

---

## 📋 Índice

### 📖 Introdução
- [01. Visão Geral](./01-visao-geral.md) - Sobre o projeto e stack tecnológica
- [02. Arquitetura do Sistema](./02-arquitetura.md) - Diagramas e fluxos

### 🔧 Backend
- [01. Estrutura de Diretórios](./backend/01-estrutura.md)
- [02. Controllers](./backend/02-controllers.md)
- [03. Use Cases](./backend/03-use-cases.md)
- [04. Repositories](./backend/04-repositories.md)
- [05. Entities e DTOs](./backend/05-entities-dtos.md)
- [06. Security](./backend/06-security.md)
- [07. Event Subscribers](./backend/07-event-subscribers.md)
- [08. Exceptions](./backend/08-exceptions.md)

### 🎨 Frontend
- [01. Estrutura de Diretórios](./frontend/01-estrutura.md)
- [02. Services (API Client)](./frontend/02-services.md)
- [03. Composables](./frontend/03-composables.md)
- [04. Componentes Vue](./frontend/04-componentes.md)
- [05. Router e Config](./frontend/05-router-config.md)
- [06. Utils](./frontend/06-utils.md)
- [07. Types](./frontend/07-types.md)

### 🔄 Integração
- [01. Comunicação e Protocolos](./integracao/01-comunicacao.md)
- [02. Endpoints da API](./integracao/02-endpoints.md)

### 🗄️ Banco de Dados
- [01. Modelo de Dados](./banco-dados/01-modelo.md)
- [02. Tabelas e Estrutura](./banco-dados/02-tabelas.md)
- [03. Relacionamentos e Índices](./banco-dados/03-relacionamentos.md)

### 📐 Padrões e Convenções
- [01. Padrões Backend](./padroes/01-backend.md)
- [02. Padrões Frontend](./padroes/02-frontend.md)

### 🛠️ Guia de Desenvolvimento
- [01. Adicionar Novo Endpoint](./desenvolvimento/01-novo-endpoint.md)
- [02. Adicionar Novo Composable](./desenvolvimento/02-novo-composable.md)
- [03. Adicionar Novo Service](./desenvolvimento/03-novo-service.md)

### 🔍 Troubleshooting
- [01. Problemas Backend](./troubleshooting/01-backend.md)
- [02. Problemas Frontend](./troubleshooting/02-frontend.md)

### 🚀 Deploy e Infraestrutura
- [01. Variáveis de Ambiente](./deploy/01-variaveis-ambiente.md)
- [02. Build de Produção](./deploy/02-build.md)
- [03. Configuração no XAMPP](./deploy/04-xampp.md)

---

## 🚀 Início Rápido

### Para Desenvolvedores Novos

1. Comece pela [Visão Geral](./01-visao-geral.md)
2. Entenda a [Arquitetura](./02-arquitetura.md)
3. Explore o [Backend](./backend/01-estrutura.md) ou [Frontend](./frontend/01-estrutura.md) conforme sua área
4. Consulte os [Padrões](./padroes/01-backend.md) antes de começar a codar

### Para Tarefas Específicas

- **Adicionar funcionalidade**: Veja os [Guias de Desenvolvimento](./desenvolvimento/)
- **Resolver problema**: Consulte o [Troubleshooting](./troubleshooting/)
- **Fazer deploy**: Veja [Deploy e Infraestrutura](./deploy/)

---

## 📚 Recursos Adicionais

- **API Swagger**: `/api/doc` (quando backend estiver rodando)
- **Código-fonte**: Sempre a melhor referência
- **Logs**: Verificar logs do Symfony e do servidor web

---

**Última atualização**: 2024
